current_track = null;
current_location = null;
track_points = [];
updateInterval = 5000;
function parsePosition(position_str) {
var latlon_arr = position_str.split(",");
if(latlon_arr.length!=4 || position_str==",,,") return null;
var lat1 = parseInt(latlon_arr[0].substring(0,latlon_arr[0].indexOf(".")-2));
var lat2 = parseFloat(latlon_arr[0].substring(latlon_arr[0].indexOf(".")-2));
var lat = lat1 + lat2/60;
var lon1 = parseInt(latlon_arr[2].substring(0,latlon_arr[2].indexOf(".")-2));
var lon2 = parseFloat(latlon_arr[2].substring(latlon_arr[2].indexOf(".")-2));
var lon = lon1 + lon2/60;
if(latlon_arr[1]=='S') lat *= -1;
if(latlon_arr[3]=='W') lon *= -1;
return new google.maps.LatLng(lat, lon);
}
function parseUTC(utc_str) {
if(utc_str.length!=6) return null;
var now = new Date();
var utc_date = new Date( Date.UTC(now.getUTCFullYear(),now.getUTCMonth(), now.getUTCDate() ,
utc_str.substr(0,2), utc_str.substr(2,2), utc_str.substr(4,2), 0) );
return utc_date;
}
function addPointToCurrentTrack(latlon_obj) {
if(!current_track) { // Initialzie the polyline of current_track
current_track = new google.maps.Polyline({
strokeColor: '#0000FF',
strokeOpacity: 0.7,
strokeWeight: 5,
map: map
});
setAdvanced(); // set color and width
map.setZoom(DEFAULT_ZOOM); // zoom the map to large scale
map.setCenter(latlon_obj); // set center at current location
}
var path = current_track.getPath();
var path_len = path.getLength();
if(path_len > 0) {
var last_point = path.getAt(path.getLength()-1);
var latdiff = latlon_obj.lat() - last_point.lat();
var londiff = latlon_obj.lng() - last_point.lng();
var mintrackpointdelta = 0;
if(Math.sqrt(latdiff*latdiff + londiff*londiff) <= mintrackpointdelta) {
return false;
}
}
path.push(latlon_obj);
return true;
}
function updateCurrentTrack() {
$.ajax({
url: append_url("track_viewer_sta.xml?rc="),
type: "GET",
dataType: "xml",
error: function(xmlDoc){
console.log("Fail to load track_viewer_sta.xml!");
},
success: function(xmlDoc) {
var current_position = xml_getvalue(xmlDoc,"gnss_position",0);
var current_time = xml_getvalue(xmlDoc,"gnss_utc",0);
var current_speed = xml_getvalue(xmlDoc,"gnss_speed",0);
latlon_obj = parsePosition(current_position);
if(latlon_obj) { // valid position
track_points.push({latlon: latlon_obj, time: parseUTC(current_time), speed: current_speed});
var add_status = addPointToCurrentTrack(latlon_obj);
if(add_status) { // add a new point to polyline, so need to update the current location
if(!current_location) { // Initilize the marker
current_location = new google.maps.Marker({
position: latlon_obj,
icon: {url: 'bus_icon.png', anchor: new google.maps.Point(15, 15)},
map: map,
title: GetElmCont("gnss_0","Current location")
});
}
else { // Update the position
current_location.setPosition(latlon_obj);
}
}
}
else {
if(map.getCenter()==null) {
map.setZoom(DEFAULT_ZOOM); // zoom the map to large scale
map.setCenter({lat: DEFAULT_LAT, lng: DEFAULT_LON }); // set center at current location
}
}
}
});
timer = setTimeout("updateCurrentTrack()",updateInterval);
}
function setCenterAndZoomForCurrentTrack() {
if(!current_track) return;
var maxlat = -90;
var minlat = 90;
var maxlon = -180;
var minlon = 180;
var path = current_track.getPath();
var path_len = path.getLength();
var lat;
var lon;
for(var i=0; i < path_len; ++i) {
var point = path.getAt(i);
lat = point.lat();
lon = point.lng();
if(lat > maxlat) maxlat = lat;
if(lat < minlat) minlat = lat;
if(lon > maxlon) maxlon = lon;
if(lon < minlon) minlon = lon;
}
if(path_len==0) {
return;
}
else if(path_len==1) {
map.setZoom(DEFAULT_ZOOM); // zoom the map to large scale
map.setCenter(new google.maps.LatLng(lat, lon)); // set center at current location
return;
}
var centerlon = (maxlon + minlon) / 2;
var centerlat = (maxlat + minlat) / 2;
var bounds = new google.maps.LatLngBounds(
new google.maps.LatLng(minlat, minlon),
new google.maps.LatLng(maxlat, maxlon));
map.fitBounds(bounds);
map.setCenter(new google.maps.LatLng(lat, lon));
var new_zoom = (map.getZoom() > 15) ? 15 : map.getZoom()-1 ;
map.setZoom(new_zoom);
}
function getCurrentTrackData() {
var res = [];
for(var i=0; i < track_points.length; ++i) {
res.push([track_points[i].time.getTime(), track_points[i].speed]);
}
return res;
}
function showCurrentTrack() {
if(parser) {
parser.clearMap();
parser = null;
}
if(current_track) {
current_track.setMap(map);
}
if(current_location) {
current_location.setMap(map);
}
if(timer==0) { // if timer is not set, set the timer to update current track
updateCurrentTrack();
}
setCenterAndZoomForCurrentTrack(); // set center and zoom for current track
showDetailPanel(false); // hide the detail panel
}
function hideCurrentTrack() {
if(current_track) { current_track.setMap(null); }
if(current_location) { current_location.setMap(null); }
}